/****** Object:  StoredProcedure [dbo].[P_PDV_VD_IT_REPROCESSAR_CUSTO]    Script Date: 10/09/2013 18:32:56 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_DEV_EST_PROD_IMP_REPROCESSAR_CUSTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PDV_VD_DEV_EST_PROD_IMP_REPROCESSAR_CUSTO]
GO
GO
GO
--EXEC P_PDV_VD_DEV_EST_PROD_IMP_REPROCESSAR_CUSTO 05,2020,13
CREATE PROCEDURE [dbo].[P_PDV_VD_DEV_EST_PROD_IMP_REPROCESSAR_CUSTO]( @MES INT=NULL, 
														@ANO INT=NULL,
														@CD_FILIAL_PAR INT=0,
														@TIPO_CUSTO INT=0,
														@DT_PROC DATETIME=NULL,
														@CD_PROD INT=0)  AS
	
	DECLARE @DT_INI DATETIME
	DECLARE @DT_FIM DATETIME
	DECLARE @DIA DATETIME
	DECLARE @CD_FILIAL AS INT
	DECLARE @AGORA DATETIME 
	declare @Inicial int =0
		 
	IF @CD_FILIAL_PAR <=0
	BEGIN
		Print 'informe a filial para processamento'
		RETURN
	END	

	SET NOCOUNT ON
	IF  @DT_PROC IS NULL
		begin
			IF @ANO IS NULL OR @MES IS NULL
				begin
					SELECT @AGORA=DATEADD(month, -1, GETDATE()), @ANO=YEAR(@AGORA), @MES=MONTH(@AGORA)
				end
			
			SET @DT_INI = CONVERT(DATETIME, (CONVERT(VARCHAR, (@ANO*100+@MES)) + '01')) ;
			SET @DT_FIM = dbo.F_FINAL_MES (@DT_INI) ;
		end
		
	IF  NOT @DT_PROC IS NULL
		begin
			SET @DT_INI = @DT_PROC;
			SET @DT_FIM = @DT_PROC;
		end
	
	--Roda   ate hoje
	IF  @DT_FIM > DBO.F_HOJE()
	BEGIN
		SET @DT_FIM = DBO.F_HOJE() 
	END
	
	
/*****************************************************************************************************************************/
--Relacao produtos
/*****************************************************************************************************************************/
	IF  OBJECT_ID('TEMPDB.DBO.#RsProd_Devo') IS NOT NULL
	begin
		 DROP TABLE #RsProd_Devo
	end

	CREATE TABLE #RsProd_Devo (CD_EMP INT,
								CD_FILIAL INT,
								CD_PROD INT, 
								VLR_CUSTO_MEDIO Money default(0),
								VLR_CUSTO Money default(0)
						)  


/*****************************************************************************************************************************/
--Configurao para custo inicial dia venda..
/*****************************************************************************************************************************/
	IF @TIPO_CUSTO = 0 
	begin 
		IF ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP=1 AND CD_CHAVE= 'CUSTO_MEDIO_INICIO_DIA_VENDAS'),0)=1
		BEGIN
			set @Inicial= 10;
		END
	end

/*****************************************************************************************************************************/

	DECLARE @NMTBL VARCHAR(100), @CMD VARCHAR(500);
	SET @NMTBL = 'EST_FECHA_PROC_MOV_PEND_TBL_PROC_' +CONVERT(VARCHAR,@CD_FILIAL_PAR);

	IF NOT OBJECT_ID(@NMTBL) IS NULL
	BEGIN
				
		SET @CMD = 'INSERT INTO #RsProd_Devo(CD_EMP, CD_FILIAL, CD_PROD)
					SELECT  DISTINCT CD_EMP, CD_FILIAL, CD_PROD
					FROM ' + @NMTBL + ' WHERE CD_EMP= 1 ' 
		SET @CMD = @CMD+ 'AND CD_FILIAL =' + convert(varchar,@CD_FILIAL_PAR) 

		IF NOT @DT_PROC  IS NULL
			SET @CMD = @CMD+ ' AND DT_PROC =''' + convert(varchar,@DT_PROC,112)  + ''''
		EXEC (@CMD);
	END 

	if @CD_PROD > 0 --or @CD_FILIAL_PAR > 0
		DELETE FROM #RsProd_Devo;

	if not exists(select top 1 cd_emp from #RsProd_Devo)
	BEGIN
		DELETE FROM #RsProd_Devo;
		PRINT 'Atualizando a tabela de devolucao'

		if  @CD_PROD > 0 --Colocado no if para performance
			begin
				INSERT INTO #RsProd_Devo(CD_EMP, CD_FILIAL, CD_PROD)
				SELECT DISTINCT 
					CD_EMP, 
					CD_FILIAL, 
					CD_PROD
				FROM 
					PDV_VD_DEV_EST_PROD_IMP i
				WHERE
					i.CD_EMP =1
					AND i.CD_FILIAL = @CD_FILIAL_PAR
					AND i.CD_PROD =  @CD_PROD  
					and i.DT_devo between  @DT_INI and  @DT_FIM ;	
			end
		else
		begin
			INSERT INTO #RsProd_Devo(CD_EMP, CD_FILIAL, CD_PROD)
			SELECT DISTINCT 
				CD_EMP, 
				CD_FILIAL, 
				CD_PROD
			FROM 
				PDV_VD_DEV_EST_PROD_IMP i
			WHERE
				i.CD_EMP =1
				AND i.CD_FILIAL = @CD_FILIAL_PAR 
				and i.DT_DEVO between  @DT_INI and  @DT_FIM ;	
		end
	END
		
	CREATE UNIQUE CLUSTERED INDEX ix_RsProd_Devo  ON #RsProd_Devo (CD_PROD,CD_FILIAL,CD_EMP);			
		
/*****************************************************************************************************************************/ 

	PRINT 'Custo do movimento de devolucao de cupons  ' + CONVERT(VARCHAR, GETDATE (),108)
	
	DECLARE cFilialPdvDev CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  
	 	CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE 
		CD_EMP = 1  
		AND CD_FILIAL in (select distinct cd_filial from #RsProd_Devo)
	ORDER BY
			CD_FILIAL;

	OPEN cFilialPdvDev
	FETCH NEXT FROM cFilialPdvDev INTO @CD_FILIAL

	WHILE @@FETCH_STATUS=0
	begin
		SET @DIA = @DT_INI
		WHILE @DT_FIM >= @DIA
			begin
				PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' -  Processando dia  ' + CONVERT(VARCHAR, @DIA, 112) + ' ' + CONVERT(VARCHAR, GETDATE (),108)  + ' Tipo ' + convert(varchar(10),@TIPO_CUSTO)
				IF @TIPO_CUSTO = 0 
					begin
						UPDATE
							p
						SET  
							VLR_CUSTO_MEDIO  = dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (p.CD_EMP,p.CD_FILIAL,p.CD_PROD,@DIA,@Inicial),
							VLR_CUSTO		  = dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (p.CD_EMP,p.CD_FILIAL,p.CD_PROD,@DIA,6)
						from
							 #RsProd_Devo p 
						WHERE
							    p.CD_EMP = 1 
							AND p.CD_FILIAL = @CD_FILIAL 
							
					end		
								
				 	
				IF @TIPO_CUSTO = 1 
				begin

				    UPDATE
				    p
				    SET  
					   VLR_CUSTO_MEDIO  = dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (p.CD_EMP,p.CD_FILIAL,p.CD_PROD,@DIA,2),
					   VLR_CUSTO		  = dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (p.CD_EMP,p.CD_FILIAL,p.CD_PROD,@DIA,2)
				    from
					   #RsProd_Devo p 
				    WHERE
					   p.CD_EMP = 1 
					   AND p.CD_FILIAL = @CD_FILIAL 
				end
						
				UPDATE
				    i
				SET  
				    VLR_CUSTO_MEDIO = p.VLR_CUSTO_MEDIO,
				    VLR_CUSTO		= p.VLR_CUSTO
				from
				    PDV_VD_DEV_EST_PROD_IMP i	
				    inner join #RsProd_Devo p on 
				    i.cd_emp = p.cd_emp and
				    i.cd_filial = p.cd_filial and
				    i.cd_prod = p.cd_prod
				WHERE
					   i.CD_EMP = 1 
				    AND i.CD_FILIAL = @CD_FILIAL 
				    AND i.DT_DEVO = @DIA 
				    and ( i.VLR_CUSTO_MEDIO <>  p.VLR_CUSTO_MEDIO  or
							 i.VLR_CUSTO		<>  p.VLR_CUSTO  )	

				SELECT @DIA = @DIA + 1
			end		
		FETCH NEXT FROM  cFilialPdvDev INTO @CD_FILIAL 
	end
	
	PRINT 'Fim do processo de custo do movimento de devolucao de cupons  ' + CONVERT(VARCHAR, GETDATE (),108);
	
CLOSE cFilialPdvDev
DEALLOCATE cFilialPdvDev

IF  OBJECT_ID('TEMPDB.DBO.#RsProd_Devo') IS NOT NULL
	begin
		 DROP TABLE #RsProd_Devo
	end
